// Get all rows with class "row"
var rows = document.querySelectorAll(".row");

//Default state: Hide all rows except the one with id "general1"
rows.forEach(function (row) {
 if (row.id !== "general1") {
   row.style.display = "none";
   removeRequired(row);
 } else {
   setRequired(row);
 }
});

// Add change event listener to the dropdown
var staffSelect = document.getElementById("staff-status");
staffSelect.addEventListener("change", function () {
 showRows();
});

function showRows() {
 var selectedValue = document.getElementById("staffStatus");
 var trimmed = selectedValue.textContent.trim();

 console.log(trimmed);

 // Hide all sections initially
 var sections = [
     "preliminary",
     "academic_and_non_academic_1",
     "academic",
     "annual_performance",
     "junior1",
     "junior2",
     "junior_1",
     "junior_2"
 ];

 // Hide all sections first and remove required attribute
 sections.forEach(function (section) {
     var sectionElement = document.getElementById(section);
     if (sectionElement) { // Check if the element exists
         sectionElement.style.display = "none";
         removeRequired(sectionElement);
     }
 });
 // Show and set required based on the trimmed value
 switch (trimmed) {
     case "Senior Staff Non Academic":
         var section = document.getElementById("academic_and_non_academic_1");
         section.style.display = "block";
         setRequired(section);
         break;

     case "Senior Staff Academic":
         var section = document.getElementById("academic");
         section.style.display = "block";
         setRequired(section);
         break;

     case "Management Staff Academic":
         document.getElementById("preliminary").style.display = "block";
         setRequired(document.getElementById("preliminary"));

         var academicSection = document.getElementById("academic");
         academicSection.style.display = "block";
         setRequired(academicSection);

         document.getElementById("junior_1").style.display = "block";
         setRequired(document.getElementById("junior_1"));

         document.getElementById("junior_2").style.display = "block";
         setRequired(document.getElementById("junior_2"));

         // Optionally hide sections not required
         document.getElementById("junior1").style.display = "none";
         document.getElementById("junior2").style.display = "none";
         break;

     case "Management Staff Non Academic":
         document.getElementById("preliminary").style.display = "block";
         setRequired(document.getElementById("preliminary"));

         var section = document.getElementById("academic_and_non_academic_1");
         section.style.display = "block";
         setRequired(section);

         document.getElementById("junior_1").style.display = "block";
         setRequired(document.getElementById("junior_1"));

         document.getElementById("junior_2").style.display = "block";
         setRequired(document.getElementById("junior_2"));

         // Optionally hide sections not required
         document.getElementById("junior1").style.display = "none";
         document.getElementById("junior2").style.display = "none";
         break;

     case "Junior Staff":
         var section = document.getElementById("preliminary");
         section.style.display = "block";
         setRequired(section);

         document.getElementById("junior1").style.display = "block";
         setRequired(document.getElementById("junior1"));

         document.getElementById("junior2").style.display = "block";
         setRequired(document.getElementById("junior2"));

         // Optionally hide sections not required
         document.getElementById("junior_1").style.display = "none";
         document.getElementById("junior_2").style.display = "none";
         break;

     default:
         break;
 }
}

function setRequired(row) {
 if (row.id !== "checkbox-container") {
     var inputs = row.querySelectorAll("input, textarea");
     inputs.forEach(function (input) {
         if (input.type !== "checkbox") {
             input.setAttribute("required", "");
         }
     });
 }
}

function removeRequired(row) {
 if (row.id !== "checkbox-container") {
     var inputs = row.querySelectorAll("input, textarea");
     inputs.forEach(function (input) {
         if (input.type !== "checkbox") {
             input.removeAttribute("required");
         }
     });
 }
}




// Utility function to add a new row
function addNewRow(containerId, rowHtml) {
 var container = document.getElementById(containerId);
 if (container) {
     container.insertAdjacentHTML("beforeend", rowHtml);
     initDatePicker();
 }
}

function initDatePicker() {
 $(".datepicker").datetimepicker({
     timepicker: false,
     format: "Y-m-d",
 });
}

// Event Handlers for adding rows
function add_key_goals() {
 addNewRow("key_goals_item", `
     <tr>
         <td><textarea class="form-control" name="key_goals[]" rows="2" required></textarea></td>
         <td width="100">
             <a class="btn btn-info btn-sm" onClick="add_key_goals()">
                 <i class="fa fa-plus-square" aria-hidden="true"></i>
             </a>
             <a class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                 <i class="fa fa-trash" aria-hidden="true"></i>
             </a>
         </td>
     </tr>
 `);
}

function add_exp_teaching() {
 addNewRow("add_exp_teaching", `
     <tr>
         <td><textarea name="exp_institutions[]" class="form-control" rows="1" required></textarea></td>
         <td><input type="text" name="exp_designation[]" class="form-control" required></td>
         <td><input type="text" name="exp_specialization[]" class="form-control" required></td>
         <td><input type="text" name="exp_subject[]" class="form-control" required></td>
         <td><input type="text" name="exp_date[]" class="form-control datepicker" required></td>
         <td>
             <a class="btn btn-info btn-sm" onClick="add_exp_teaching()">
                 <i class="fa fa-plus-square" aria-hidden="true"></i>
             </a>
             <a class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                 <i class="fa fa-trash" aria-hidden="true"></i>
             </a>
         </td>
     </tr>
 `);
}

function exp_professional() {
 addNewRow("exp_professional", `
     <tr>
         <td><textarea name="exp_institutions[]" class="form-control" rows="1" required></textarea></td>
         <td><input type="text" name="exp_designation[]" class="form-control" required></td>
         <td><textarea name="exp_duty[]" class="form-control" rows="2" required></textarea></td>
         <td><input type="text" name="exp_subject[]" class="form-control" required></td>
         <td><input type="text" name="exp_date_start[]" class="form-control datepicker" required></td>
         <td><input type="text" name="exp_date_end[]" class="form-control datepicker" required></td>
         <td>
             <a class="btn btn-info btn-sm" onClick="exp_professional()">
                 <i class="fa fa-plus-square" aria-hidden="true"></i>
             </a>
             <a class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                 <i class="fa fa-trash" aria-hidden="true"></i>
             </a>
         </td>
     </tr>
 `);
}

function exp_research() {
 addNewRow("exp_research", `
     <tr>
         <td><textarea name="exp_researh_topic[]" class="form-control" rows="2" required></textarea></td>
         <td><input type="text" name="exp_researh_date[]" class="form-control datepicker" required></td>
         <td>
             <a class="btn btn-info btn-sm" onClick="exp_research()">
                 <i class="fa fa-plus-square" aria-hidden="true"></i>
             </a>
             <a class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                 <i class="fa fa-trash" aria-hidden="true"></i>
             </a>
         </td>
     </tr>
 `);
}

function exp_research_unpublish() {
 addNewRow("exp_research_unpublish", `
     <tr>
         <td><textarea name="exp_unpublish_topic[]" class="form-control" rows="2" required></textarea></td>
         <td><textarea name="exp_unpublish_read[]" class="form-control" rows="2" required></textarea></td>
         <td><input type="text" name="exp_unpublish_date[]" class="form-control datepicker" required></td>
         <td>
             <a class="btn btn-info btn-sm" onClick="exp_research_unpublish()">
                 <i class="fa fa-plus-square" aria-hidden="true"></i>
             </a>
             <a class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                 <i class="fa fa-trash" aria-hidden="true"></i>
             </a>
         </td>
     </tr>
 `);
}

function key_duties_res() {
 addNewRow("key_duties_res", `
     <tr>
         <td><textarea name="duties_responsibilites[]" class="form-control" required></textarea></td>
         <td><textarea name="special_contributions[]" class="form-control" required></textarea></td>
         <td><textarea name="duties_perf_circumstances[]" class="form-control" required></textarea></td>
         <td><textarea name="duties_perf_circumstances_bad[]" class="form-control" required></textarea></td>
         <td>
             <a class="btn btn-info btn-sm" onClick="key_duties_res()">
                 <i class="fa fa-plus-square" aria-hidden="true"></i>
             </a>
             <a class="btn btn-danger btn-sm" onclick="deleteRow(this)">
                 <i class="fa fa-trash" aria-hidden="true"></i>
             </a>
         </td>
     </tr>
 `);
}

// General function to delete a row
function deleteRow(e) {
 var rowCount = e.closest('tbody').rows.length;
 if (rowCount > 1) {
     e.closest('tr').remove();
 } else {
     alert("There is only one row, you can't delete it.");
 }
}
