function showRows() {
    var selectedValue = document.getElementById("staff_status").innerHTML;
  
    // Hide all general rows and remove required attribute
    var generalRows = document.querySelectorAll("[id^='general']");
    generalRows.forEach(function(row) {
      row.style.display = "none";
    });
  
    // Hide specific sections initially
    var sections = [
      "academic_and_non_academic_1",
      "tb",
      "academic_and_non_academic_2",
      "academic",
      "management_staff",
      "preliminary",
      "annual_performance",
      "junior1",
      "junior2",
      "junior_1",
      "junior_2"
    ];
    sections.forEach(function(id) {
      document.getElementById(id).style.display = "none";
    });
  
    if (selectedValue) {
      // Show all general rows and set required attribute
      generalRows.forEach(function(row) {
        row.style.display = "block";
      });
  
      switch (selectedValue) {
        case "Senior Non Academic":
          document.getElementById("academic_and_non_academic_1").style.display = "block";
          document.getElementById("tb").style.display = "block";
          document.getElementById("academic_and_non_academic_2").style.display = "block";
          break;
  
        case "Senior Academic":
          document.getElementById("tb").style.display = "block";
          document.getElementById("academic").style.display = "block";
          document.getElementById("academic_and_non_academic_2").style.display = "block";
          break;
  
        case "Management Staff":
          document.getElementById("preliminary").style.display = "block";
          document.getElementById("management_staff").style.display = "block";
          document.getElementById("academic").style.display = "block";
          document.getElementById("junior1").style.display = "none";
          document.getElementById("junior2").style.display = "none";
          document.getElementById("junior_1").style.display = "block";
          document.getElementById("junior_2").style.display = "block";
          break;
  
        case "Management Staff Non":
          document.getElementById("preliminary").style.display = "block";
          document.getElementById("management_staff").style.display = "block";
          document.getElementById("academic_and_non_academic_1").style.display = "block";
          document.getElementById("junior1").style.display = "none";
          document.getElementById("junior2").style.display = "none";
          document.getElementById("junior_1").style.display = "block";
          document.getElementById("junior_2").style.display = "block";
          break;
  
        case "Junior staff":
          document.getElementById("preliminary").style.display = "block";
          document.getElementById("annual_performance").style.display = "block";
          document.getElementById("junior1").style.display = "block";
          document.getElementById("junior2").style.display = "block";
          document.getElementById("junior_1").style.display = "none";
          document.getElementById("junior_2").style.display = "none";
          break;
  
        default:
          break;
      }
    }
  }
  
  // Add event listener to run the function on page load
  document.addEventListener("DOMContentLoaded", function() {
    showRows();
  });
  